
#********************************************************************************
#If you should have any comments, suggestions or improvements to these samples, 
#we welcome you to contact us at SampleCode@melissadata.com also please visit our 
#developers bulletin board at forum.melissadata.com.
#********************************************************************************

import mdNamePythonWrapper 

# Put your License String and Path to Name Object Data Files here

	#/********************** LICENSE STRINGS **********************
	#*     To unlock the full functionality of Name Object,       *
	#*     	     Or to obtain a Demo License String               *
	#* please call a sales representative at 1-800-MELISSA ext. 3 *
	#*         (1-800-635-4772 x3) for a license string.          *
        #**************************************************************/

License = r"License Here"
DataPath = r"C:\Program Files\Melissa Data\DQT\Data"


mdName = mdNamePythonWrapper.mdName()

# Set License String
if not mdName.SetLicenseString(License):
    print "License String is not Valid. To unlock the full functionality of Name Object," 
    print " please call a sales representative at 1-800-MELISSA ext. 3" 
    exit()

# Initialize
mdName.SetPathToNameFiles(DataPath)
result = mdName.InitializeDataFiles()

if result != 0:
    print "Initialize Error: ", mdName.GetInitializeErrorString()
    exit()
print "======================================"
print "      NAME OBJECT PYTHON EXAMPLE"
print "======================================"
print "             BuildNumber: ", mdName.GetBuildNumber() 
print "           Database Date: ", mdName.GetDatabaseDate()
print "Database Expiration Date: ", mdName.GetDatabaseExpirationDate()
print " License Expiration Date: ", mdName.GetLicenseExpirationDate() 
print "======================================\n"

mdName.SetFirstNameSpellingCorrection(True)
mdName.SetPrimaryNameHint(4)
mdName.SetSalutationPrefix("Dear")
mdName.SetSalutationSuffix(":")
mdName.SetSalutationSlug("Valued Customer")

while(1):
    Name = raw_input("Enter Full Name: ")
    if (Name == '0'):
       break
    mdName.SetFullName(Name)
    mdName.Parse()

    print "      Prefix: ", mdName.GetPrefix()
    print "  First Name: ", mdName.GetFirstName()
    print " Middle Name: ", mdName.GetMiddleName()
    print "   Last Name: ", mdName.GetLastName()
    print "      Suffix: ", mdName.GetSuffix()
    print "      Gender: ", mdName.GetGender()
    print "     Prefix2: ", mdName.GetPrefix2()
    print " First Name2: ", mdName.GetFirstName2()
    print "Middle Name2: ", mdName.GetMiddleName2()
    print "  Last Name2: ", mdName.GetLastName2()
    print "     Suffix2: ", mdName.GetSuffix2()
    print "     Gender2: ", mdName.GetGender2()
    print "  Salutation: ", mdName.GetSalutation()
    print "\n"
    print "Results Codes... "
    ResultsString = mdName.GetResults()
    
    if (ResultsString.find("NS01")!= -1):
	     print "NS01: There were no Errors"
    if (ResultsString.find("NS03")!= -1):
	     print "NS03: The spelling of the FirstName field was corrected"
    if (ResultsString.find("NS04")!= -1):
	     print "NS04: The spelling of the FirstName2 field was corrected"
    if (ResultsString.find("NS02")!= -1):
	     print "NS02: There was a parse error..."
    if (ResultsString.find("NE01")!= -1):
	     print "NE01: Two names were detected but the FullName string was not in a recognized format"
    if (ResultsString.find("NE02")!= -1):
			 print "NE02: Multiple first names - could not accurately genderize"
    if (ResultsString.find("NE03")!= -1):
	     print "NE03: A vulgarity was detected in the name"
    if (ResultsString.find("NE04")!= -1):
	     print "NE04: The name contained words found on the list of nuisance names [such as Mickey Mouse]"
    if (ResultsString.find("NE05")!= -1):
	     print "NE05: The name contained words normally found in a company name"
    if (ResultsString.find("NE06")!= -1):
			 print "NE06: The named contained a non-alphabetic character"

    print "\n"
    print "To quit program, input Name: '0' \n"
userinput = raw_input("Goodbye, Press <Enter> to quit... ")